package w83b.w83bOperacionesPaso.w83bListados.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;

import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaLibroRegActasExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListLibroRegActas.xls";
		InputStream inputStream = W83bTablaLibroRegActasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaLibroRegActas = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)6);
        
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)8); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)6);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)8); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        row = sheet.getRow((short)9); // Creacin de la fila 1
        cell = row.getCell((short)0);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.libroRegistroEntrada",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.libroRegistroEntrada",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.numactadesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.numactadesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
       
        cell = row.getCell((short)3); 
        if ("".equals(listadoBean.getNumTerritorio())){
        	listadoBean.setNumTerritorio("-");
        }
        if ("".equals(listadoBean.getAnyoActa())){
        	listadoBean.setAnyoActa("-");
        }
        StringBuffer sb=new StringBuffer();
		if ("".equals(listadoBean.getNumActa())){
			listadoBean.setNumPreaviso("-");
		}else{
			String v=W83bUtilidadesComunes.rellenarCeros(listadoBean.getNumActa());
			sb.append(v);
		} 
		if(StringUtils.isNotEmpty(listadoBean.getNumTerritorio()) && StringUtils.isNotEmpty(listadoBean.getAnyoActa()) ){
			cell.setCellValue(listadoBean.getNumTerritorio()+"/"+listadoBean.getAnyoActa()+"/"+sb.toString());
		}
        cell.setCellStyle(excel.styleTexto9);
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("3"),11,Short.parseShort("5")));//NOPMD
		}
        cell = row.getCell((short)4);
        cell.setCellStyle(excel.styleTexto9);
//        cell = row.getCell((short)5); 
//        cell.setCellStyle(excel.styleTexto9);
        cell = row.getCell((short)6); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaDesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)7); 
        cell.setCellStyle(excel.styleTexto9);
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaDesde()) ){
        	cell.setCellValue(listadoBean.getFechaEntradaDesde());
        }
       
        cell = row.getCell((short)10); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaHasta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechentradaHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)12); 
        if(StringUtils.isNotEmpty(listadoBean.getFechaEntradaHasta()) ){
        	cell.setCellValue(listadoBean.getFechaEntradaHasta());
        }
        cell.setCellStyle(excel.styleTexto9);
        
       
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)13);
        cell = row.getCell((short)0);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)1);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)2);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preaviso",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_preaviso",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)3);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cif",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)4);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)5);
        cell2 = row.getCell((short)6);
        sheet.addMergedRegion(new Region((short)13,(short)5,(short)13,(short)6)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)7);
        cell2 = row.getCell((short)8);
        sheet.addMergedRegion(new Region((short)13,(short)7,(short)13,(short)8)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)9);
        cell2 = row.getCell((short)10);
        sheet.addMergedRegion(new Region((short)13,(short)9,(short)13,(short)10)); //NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        
        cell = row.getCell((short)11);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.convenio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.convenio",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)12);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.comarca",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.comarca",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)13);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        cell = row.getCell((short)14);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        for(int i=0;i<listaLibroRegActas.size();i++){
        	row = sheet.createRow((short)14+i); // Creacin de la fila 1
        	
        	cell = row.createCell((short)0); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getFechaEntrada())){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getFechaEntrada());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)1); 
        	sb = new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
        	
        	String valor=W83bUtilidadesComunes.rellenarCeros(((W83bListadosBean)listaLibroRegActas.get(i)).getNumActa());
        	sb=sb.append(valor);
 		
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio()) &&
        			StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoActa()) ){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio()+"/"+((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoActa()+"/"+sb.toString());
        	}
        	
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)2); 
        	 if (((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio()==null){
             	((W83bListadosBean)listaLibroRegActas.get(i)).setTerritorio("-");
             }
             if (((W83bListadosBean)listaLibroRegActas.get(i)).getAnopreaviso()==null){
            	 ((W83bListadosBean)listaLibroRegActas.get(i)).setAnopreaviso("-");
             }
     		if (((W83bListadosBean)listaLibroRegActas.get(i)).getNPre()==null){
     			cell.setCellValue("");
     		}
     		else{
     			sb = new StringBuffer();//NOPMD
     			valor=W83bUtilidadesComunes.rellenarCeros(((W83bListadosBean)listaLibroRegActas.get(i)).getNPre());
     			sb.append(valor);
     			((W83bListadosBean)listaLibroRegActas.get(i)).setNPre(valor);
     			((W83bListadosBean)listaLibroRegActas.get(i)).setNPre(sb.toString());
     			if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio()) &&
            			StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getAnyoActa()) ){
     				cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getTerritorio()+"/"+((W83bListadosBean)listaLibroRegActas.get(i)).getAnopreaviso()+"/"+((W83bListadosBean)listaLibroRegActas.get(i)).getNPre());
     			}
     		}
     		
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)3); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getCif() )){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getCif()));
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)4); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getCodCentro())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bListadosBean)listaLibroRegActas.get(i)).getCodCentro()));
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	cell = row.createCell((short)5); 
        	cell2 = row.createCell((short)6); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)5,(short)14+i,(short)6)); //NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getRazon() )){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getRazon()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)7); 
        	cell2 = row.createCell((short)8); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)7,(short)14+i,(short)8)); //NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getDireccion() )){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getDireccion()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)9); 
        	cell2 = row.createCell((short)10); 
        	sheet.addMergedRegion(new Region((short)14+i,(short)9,(short)14+i,(short)10)); //NOPMD
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getMunicipio() )){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getMunicipio()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell2.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)11); 
        	if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
        		if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getConvenio() )){
        			cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getConvenio()));
        		}
            }
            else{
            	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getConvenioeu() )){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getConvenioeu()));
            	}
            }
        	
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)12); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getComarca() )){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bListadosBean)listaLibroRegActas.get(i)).getComarca()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	cell = row.createCell((short)13); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getNumelectores() )){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getNumelectores());
        	}
        	cell.setCellStyle(estiloFilaNumero(i,excel));
        	
        	cell = row.createCell((short)14); 
        	if(StringUtils.isNotEmpty(((W83bListadosBean)listaLibroRegActas.get(i)).getNumrep() )){
        		cell.setCellValue(((W83bListadosBean)listaLibroRegActas.get(i)).getNumrep());
        	}
        	cell.setCellStyle(estiloFilaNumero(i,excel));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoLibroRegActas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumero;
		}else{
			return excel.styleTextoImparNumero;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}

}
